# SoftAPI Proxy API

Production-ready PHP-based proxy API system for SoftAPI gaming provider.

## Requirements

- PHP 8.0+
- MySQL 5.7+ / MariaDB
- PDO, OpenSSL, JSON extensions

## Installation

1. Copy `.env.example` to `.env` and configure:
   ```bash
   cp .env.example .env
   ```

2. Set credentials in `.env`:
   ```
   SOFTAPI_TOKEN=your_main_api_token
   SOFTAPI_SECRET=your_32_byte_secret_key
   DB_NAME=softapi_proxy
   DB_USER=root
   DB_PASS=your_password
   PROXY_BASE_URL=https://yourdomain.com
   ADMIN_PASSWORD=secure_admin_password
   ```

3. Import schema and seed:
   ```bash
   mysql -u root -p < database/schema.sql
   mysql -u root -p softapi_proxy < database/seed.sql
   ```

4. Point document root to project root (or configure vhost for `/admin` and API).

## API Endpoints

### Launch Game
`GET|POST /api/launch-game`

| Parameter | Required | Description |
|-----------|----------|-------------|
| api_key | Yes | Client API key |
| user_id | Yes | User ID |
| balance | Yes | User balance |
| game_uid | Yes | Game session ID |
| return_url | No | Return URL after game |
| callback_url | No | Client callback URL |
| currency_code | No | e.g. BDT |
| language | No | e.g. bn |

### Callback
`POST /api/callback` — Receives SoftAPI callbacks, processes transactions, forwards to client.

## Admin Panel

Access at `/admin/` — login with `ADMIN_PASSWORD`.

- **Dashboard** — Total clients, bets, wins, profit
- **Clients** — Create, edit, API key, IP/domain whitelist, commission
- **Users** — View users per client with balances
- **Transactions** — Filter by client, date
- **API Logs** — Request/response logs

## Cron Job (Callback Retry)

Add to crontab for failed callback retries:
```
* * * * * php /path/to/cron/retry_callbacks.php
```

## Folder Structure

```
├── config/
├── controllers/
├── middleware/     # ValidateApiKey, CheckWhitelist, RateLimiter, SignatureValidator
├── models/
├── services/
├── admin/          # Admin panel
├── cron/           # Retry script
├── database/
├── public/         # API entry point
└── bootstrap.php
```

## Security

- Rate limiting: 10 req/sec per API key
- IP and domain whitelist per client
- PDO prepared statements
- Optional SignatureValidator for request hashing
