<?php
$clientId = !empty($_GET['client_id']) ? (int) $_GET['client_id'] : null;
$endpoint = trim($_GET['endpoint'] ?? '');
$page = max(0, (int) ($_GET['page'] ?? 0));
$limit = 50;
$offset = $page * $limit;
$clients = $di['client']->findAll();
$logs = $di['apiLog']->getList($clientId, $endpoint ?: null, $limit, $offset);
?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2>API Logs</h2>
</div>
<form method="get" class="mb-3 d-flex gap-2 flex-wrap align-items-end">
    <input type="hidden" name="p" value="logs">
    <div><label class="form-label small">Client</label><select name="client_id" class="form-select form-select-sm bg-dark text-white" style="width:160px"><option value="">All</option><?php foreach ($clients as $c): ?><option value="<?= $c['id'] ?>" <?= $clientId === (int)$c['id'] ? 'selected' : '' ?>><?= htmlspecialchars($c['name']) ?></option><?php endforeach; ?></select></div>
    <div><label class="form-label small">Endpoint</label><input type="text" name="endpoint" class="form-control form-control-sm bg-dark text-white" placeholder="/api/..." value="<?= htmlspecialchars($endpoint) ?>"></div>
    <button type="submit" class="btn btn-sm btn-success">Filter</button>
</form>
<div class="card">
    <div class="table-responsive">
        <table class="table mb-0 table-sm">
            <thead><tr><th>ID</th><th>Client</th><th>Endpoint</th><th>IP</th><th>Status</th><th>Request</th><th>Response</th><th>Date</th></tr></thead>
            <tbody>
                <?php foreach ($logs as $l): ?>
                <tr>
                    <td><?= (int) $l['id'] ?></td>
                    <td><?= htmlspecialchars($l['client_name'] ?? '-') ?></td>
                    <td><code class="small"><?= htmlspecialchars($l['endpoint']) ?></code></td>
                    <td class="small"><?= htmlspecialchars($l['ip'] ?? '') ?></td>
                    <td><?= (int) ($l['status'] ?? 0) ?></td>
                    <td><details><summary class="small">View</summary><pre class="small mb-0"><?= htmlspecialchars(is_string($l['request_payload'] ?? '') ? $l['request_payload'] : json_encode($l['request_payload'] ?? [], JSON_PRETTY_PRINT)) ?></pre></details></td>
                    <td><details><summary class="small">View</summary><pre class="small mb-0"><?= htmlspecialchars(is_string($l['response_payload'] ?? '') ? $l['response_payload'] : json_encode($l['response_payload'] ?? [], JSON_PRETTY_PRINT)) ?></pre></details></td>
                    <td class="small text-muted"><?= htmlspecialchars($l['created_at'] ?? '') ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="card-footer border-secondary"><a href="?p=logs&client_id=<?= $clientId ?? '' ?>&endpoint=<?= urlencode($endpoint) ?>&page=<?= $page + 1 ?>" class="btn btn-sm btn-outline-secondary">Load more</a></div>
</div>
