<?php
$clientId = (int) ($_GET['client_id'] ?? 0);
$clients = $di['client']->findAll();
$page = max(0, (int) ($_GET['page'] ?? 0));
$limit = 50;
$offset = $page * $limit;
$users = $clientId ? $di['user']->getByClientId($clientId, $limit, $offset) : [];
$totalUsers = $clientId ? $di['user']->countByClientId($clientId) : 0;
?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2>Users</h2>
    <form class="d-flex gap-2" method="get">
        <input type="hidden" name="p" value="users">
        <select name="client_id" class="form-select bg-dark text-white border-secondary" style="width:200px" onchange="this.form.submit()">
            <option value="0">Select client</option>
            <?php foreach ($clients as $c): ?>
            <option value="<?= $c['id'] ?>" <?= $clientId === (int)$c['id'] ? 'selected' : '' ?>><?= htmlspecialchars($c['name']) ?></option>
            <?php endforeach; ?>
        </select>
    </form>
</div>
<div class="card">
    <?php if (!$clientId): ?>
    <div class="card-body text-center text-muted">Select a client to view users.</div>
    <?php else: ?>
    <div class="table-responsive">
        <table class="table mb-0">
            <thead><tr><th>ID</th><th>User ID</th><th>Balance</th><th>Updated</th></tr></thead>
            <tbody>
                <?php foreach ($users as $u): ?>
                <tr>
                    <td><?= (int) $u['id'] ?></td>
                    <td><code><?= htmlspecialchars($u['user_id']) ?></code></td>
                    <td><?= number_format((float) $u['balance'], 2) ?></td>
                    <td><?= htmlspecialchars($u['updated_at'] ?? $u['created_at'] ?? '') ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php if ($totalUsers > $limit): ?>
    <div class="card-footer border-secondary d-flex justify-content-between">
        <span class="text-muted"><?= $totalUsers ?> total</span>
        <div>
            <?php if ($page > 0): ?><a href="?p=users&client_id=<?= $clientId ?>&page=<?= $page - 1 ?>" class="btn btn-sm btn-outline-secondary">Prev</a><?php endif; ?>
            <a href="?p=users&client_id=<?= $clientId ?>&page=<?= $page + 1 ?>" class="btn btn-sm btn-outline-secondary">Next</a>
        </div>
    </div>
    <?php endif; ?>
    <?php endif; ?>
</div>
