<?php

declare(strict_types=1);

namespace App\Middleware;

class EncryptPayload
{
    public function __invoke(array $data, string $secret): string
    {
        $json = json_encode($data);
        if ($json === false) {
            throw new \InvalidArgumentException('Failed to encode payload');
        }
        $secret = $this->ensureKeyLength($secret);
        $encrypted = openssl_encrypt($json, 'AES-256-ECB', $secret, OPENSSL_RAW_DATA);
        if ($encrypted === false) {
            throw new \RuntimeException('Encryption failed: ' . openssl_error_string());
        }
        return base64_encode($encrypted);
    }

    private function ensureKeyLength(string $key): string
    {
        $len = strlen($key);
        if ($len === 32) {
            return $key;
        }
        if ($len > 32) {
            return substr($key, 0, 32);
        }
        return str_pad($key, 32, "\0");
    }
}
