<?php

declare(strict_types=1);

namespace App\Middleware;

class RateLimiter
{
    private const LIMIT = 10;
    private const WINDOW = 1;
    private static array $cache = [];

    public function check(string $apiKey): bool
    {
        $key = 'rl:' . $apiKey;
        $now = time();
        $windowStart = $now - self::WINDOW;

        if (!isset(self::$cache[$key])) {
            self::$cache[$key] = [];
        }

        self::$cache[$key] = array_filter(self::$cache[$key], fn($t) => $t > $windowStart);

        if (count(self::$cache[$key]) >= self::LIMIT) {
            return false;
        }

        self::$cache[$key][] = $now;
        return true;
    }
}
