<?php

declare(strict_types=1);

namespace App\Middleware;

class SignatureValidator
{
    public function __construct(
        private string $secret
    ) {}

    public function validate(array $payload, string $signature): bool
    {
        if (empty($this->secret) || empty($signature)) {
            return false;
        }
        unset($payload['signature']);
        ksort($payload);
        $data = http_build_query($payload, '', '&', PHP_QUERY_RFC3986);
        $expected = hash_hmac('sha256', $data, $this->secret);
        return hash_equals($expected, $signature);
    }

    public function sign(array $payload): string
    {
        ksort($payload);
        $data = http_build_query($payload, '', '&', PHP_QUERY_RFC3986);
        return hash_hmac('sha256', $data, $this->secret);
    }
}
