<?php

declare(strict_types=1);

namespace App\Middleware;

use App\Models\Client;

class ValidateApiKey
{
    public function __construct(
        private Client $clientModel
    ) {}

    public function __invoke(string $apiKey): array
    {
        if (empty($apiKey)) {
            return ['valid' => false, 'error' => 'Missing api_key', 'client' => null];
        }

        $client = $this->clientModel->findByApiKey($apiKey);
        if (!$client) {
            return ['valid' => false, 'error' => 'Invalid or inactive api_key', 'client' => null];
        }

        return ['valid' => true, 'error' => null, 'client' => $client];
    }
}
