<?php

declare(strict_types=1);

namespace App\Models;

use PDO;

class Admin
{
    public function __construct(
        private PDO $pdo
    ) {}

    public function findByUsername(string $username): ?array
    {
        $stmt = $this->pdo->prepare('SELECT * FROM admins WHERE username = ? AND status = ?');
        $stmt->execute([$username, 'active']);
        return $stmt->fetch() ?: null;
    }

    public function verifyPassword(string $username, string $password): ?array
    {
        $admin = $this->findByUsername($username);
        if (!$admin || !password_verify($password, $admin['password_hash'])) {
            return null;
        }
        return $admin;
    }

    public function updateLastLogin(int $id): void
    {
        $this->pdo->prepare('UPDATE admins SET last_login_at = NOW() WHERE id = ?')->execute([$id]);
    }
}
