<?php

declare(strict_types=1);

namespace App\Models;

use PDO;

class ApiLog
{
    public function __construct(
        private PDO $pdo
    ) {}

    public function getList(?int $clientId = null, ?string $endpoint = null, int $limit = 100, int $offset = 0): array
    {
        $sql = 'SELECT l.*, c.name as client_name FROM api_logs l LEFT JOIN clients c ON c.id = l.client_id WHERE 1=1';
        $params = [];
        if ($clientId) {
            $sql .= ' AND l.client_id = ?';
            $params[] = $clientId;
        }
        if ($endpoint) {
            $sql .= ' AND l.endpoint LIKE ?';
            $params[] = '%' . $endpoint . '%';
        }
        $sql .= ' ORDER BY l.created_at DESC LIMIT ? OFFSET ?';
        $params[] = $limit;
        $params[] = $offset;
        $stmt = $this->pdo->prepare($sql);
        $stmt->execute($params);
        return $stmt->fetchAll();
    }
}
