<?php

declare(strict_types=1);

namespace App\Services;

class HttpService
{
    public function get(string $url): array
    {
        $context = stream_context_create([
            'http' => [
                'timeout' => 30,
                'ignore_errors' => true,
            ],
            'ssl' => [
                'verify_peer' => true,
                'verify_peer_name' => true,
            ],
        ]);

        $response = @file_get_contents($url, false, $context);

        if ($response === false) {
            $error = error_get_last();
            return [
                'success' => false,
                'body' => null,
                'code' => 0,
                'error' => $error['message'] ?? 'Request failed',
            ];
        }

        $code = 200;
        if (isset($http_response_header[0]) && preg_match('/HTTP\/\d\.\d\s+(\d+)/', $http_response_header[0], $m)) {
            $code = (int) $m[1];
        }

        return [
            'success' => $code >= 200 && $code < 300,
            'body' => $response,
            'code' => $code,
            'decoded' => json_decode($response, true),
        ];
    }

    public function postJson(string $url, array $data): array
    {
        $payload = json_encode($data);
        $context = stream_context_create([
            'http' => [
                'method' => 'POST',
                'header' => "Content-Type: application/json\r\nContent-Length: " . strlen($payload),
                'content' => $payload,
                'timeout' => 30,
                'ignore_errors' => true,
            ],
            'ssl' => [
                'verify_peer' => true,
                'verify_peer_name' => true,
            ],
        ]);

        $response = @file_get_contents($url, false, $context);

        if ($response === false) {
            $error = error_get_last();
            return [
                'success' => false,
                'body' => null,
                'code' => 0,
                'error' => $error['message'] ?? 'Request failed',
            ];
        }

        $code = 200;
        if (isset($http_response_header[0]) && preg_match('/HTTP\/\d\.\d\s+(\d+)/', $http_response_header[0], $m)) {
            $code = (int) $m[1];
        }

        return [
            'success' => $code >= 200 && $code < 300,
            'body' => $response,
            'code' => $code,
            'decoded' => json_decode($response, true),
        ];
    }
}
