<?php

declare(strict_types=1);

namespace App\Services;

use PDO;

class Logger
{
    public function __construct(
        private PDO $pdo
    ) {}

    public function log(?int $clientId, string $endpoint, ?array $request, ?array $response, ?string $ip, ?int $status): void
    {
        $stmt = $this->pdo->prepare('
            INSERT INTO api_logs (client_id, endpoint, request_payload, response_payload, ip, status)
            VALUES (?, ?, ?, ?, ?, ?)
        ');
        $stmt->execute([
            $clientId,
            $endpoint,
            $request ? json_encode($request) : null,
            $response ? json_encode($response) : null,
            $ip,
            $status,
        ]);
    }
}
